import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { X, Bell, Sparkles } from "lucide-react";

interface NotificationItemProps {
  id: string;
  message: string;
  type: "reminder" | "ai-suggestion";
  planName?: string;
  seen: boolean;
  createdAt: string;
  onDismiss?: () => void;
}

export function NotificationItem({
  id,
  message,
  type,
  planName,
  seen,
  createdAt,
  onDismiss,
}: NotificationItemProps) {
  const Icon = type === "ai-suggestion" ? Sparkles : Bell;
  const borderColor = type === "ai-suggestion" ? "border-l-ai-accent" : "border-l-primary";

  return (
    <Card
      className={`p-4 border-l-4 ${borderColor} ${!seen ? "bg-accent/50" : ""}`}
      data-testid={`notification-${id}`}
    >
      <div className="flex items-start gap-3">
        <div className={`p-2 rounded-lg ${type === "ai-suggestion" ? "bg-ai-accent/10" : "bg-primary/10"}`}>
          <Icon className={`h-4 w-4 ${type === "ai-suggestion" ? "text-ai-accent" : "text-primary"}`} />
        </div>
        
        <div className="flex-1 min-w-0 space-y-1">
          {planName && (
            <p className="text-xs font-semibold text-muted-foreground uppercase tracking-wide">
              {planName}
            </p>
          )}
          <p className="text-sm leading-relaxed">{message}</p>
          <p className="text-xs text-muted-foreground">{createdAt}</p>
        </div>

        <Button
          variant="ghost"
          size="icon"
          className="h-6 w-6"
          onClick={onDismiss}
          data-testid={`button-dismiss-notification-${id}`}
        >
          <X className="h-4 w-4" />
        </Button>
      </div>
    </Card>
  );
}
