# PlanMate AI - Design Guidelines

## Design Approach: Lovable.dev-Inspired Premium SaaS

**Selected Reference:** Lovable.dev aesthetic - vibrant gradients, glass morphism, and modern premium SaaS feel. This creates a visually striking productivity tool that feels cutting-edge and delightful.

**Core Principles:**
- Vibrant gradients as visual foundation
- Glass morphism for depth and sophistication
- Smooth, fluid animations throughout
- Premium feel with polished details
- Dark mode optimized with luminous accents

---

## Color Palette

**Dark Mode (Primary):**
- Background Base: 222 47% 11%
- Background Elevated: 222 47% 14%
- Background Card: 222 47% 16%
- Border Glow: 222 30% 25%
- Text Primary: 0 0% 98%
- Text Secondary: 0 0% 70%
- Primary (CTA): 262 83% 70% (vibrant purple/indigo)
- AI Feature: 189 94% 60% (cyan/teal for AI elements)
- Success: 142 76% 48%
- Warning: 38 92% 55%

**Gradient System:**
- Primary Hero: from-indigo-500 via-purple-500 to-teal-400 (45deg diagonal)
- Card Accents: from-purple-500/20 to-cyan-500/20
- AI Features: from-cyan-400 to-teal-500
- Hover Effects: from-indigo-600 to-purple-600

**Glass Morphism Variables:**
- Background: bg-white/5 dark:bg-white/10
- Backdrop: backdrop-blur-xl
- Border: border border-white/10
- Shadow: shadow-2xl shadow-purple-500/10

---

## Typography

**Font System:**
- Primary: Inter (Google Fonts) - all UI and body text
- Display: Plus Jakarta Sans (Google Fonts) - hero headlines, large titles

**Scale:**
- Hero Display: text-5xl md:text-6xl lg:text-7xl, font-bold, leading-tight
- Section Headers: text-3xl md:text-4xl, font-bold
- Card Titles: text-xl, font-semibold
- Body: text-base md:text-lg, leading-relaxed
- Captions: text-sm, font-medium
- Labels: text-xs, font-semibold, uppercase, tracking-wider

---

## Layout System

**Spacing Primitives:** Consistent use of 4, 6, 8, 12, 16, 20, 24
- Micro spacing: 4, 6
- Card padding: 6, 8
- Section spacing: 12, 16, 20
- Page spacing: 16, 20, 24

**Landing Page Structure:**
- Hero: Full viewport height with gradient, centered content
- Features: 3-column grid (lg:grid-cols-3 md:grid-cols-2)
- Benefits: Alternating 2-column layouts with images
- Social Proof: Centered testimonial cards
- Pricing: 3-tier comparison with highlighted middle option
- CTA Section: Full-width with gradient background
- Footer: 4-column grid with newsletter signup

**Dashboard Grid:**
- Widgets: grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4
- Main content: max-w-7xl with side panels
- Plan cards: Masonry-style staggered layout

---

## Component Library

**Navigation:**
- Header: Sticky with glass morphism (backdrop-blur-xl, bg-background/80), h-20, border-b border-white/10
- Logo left, centered nav links, CTAs right
- Mobile: Slide-in drawer with gradient overlay
- Bottom nav (PWA): Glass effect with active indicator glow

**Hero Section (Landing):**
- Full viewport with animated gradient mesh background
- Large centered headline with gradient text effect
- Subheading with glassmorphic container (p-6, rounded-2xl)
- Primary CTA (large, with glow effect) + Secondary CTA
- Hero image: 3D rendered productivity scene with floating UI elements, positioned right side on desktop, below text on mobile
- Floating accent elements: Subtle animated cards/widgets in background

**Cards:**
- Glass morphic base: rounded-2xl, p-8, border, backdrop-blur-xl
- Gradient border on hover (animate in)
- Shadow lifts on hover: shadow-2xl shadow-primary/20
- Internal gradient accents for headers
- Smooth scale transform (scale-105) on hover

**Feature Cards (Landing):**
- Icon with gradient background circle (size-16)
- Title with gradient text on hover
- Description with secondary text
- Hover: Card lifts, gradient border appears, icon slightly rotates
- Grid: 3 columns desktop, 2 tablet, 1 mobile with gap-8

**Buttons:**
- Primary CTA: Gradient background, rounded-xl, px-8 py-4, font-semibold, text-lg, glow effect
- Secondary: Glass morphic with border, hover fills with subtle gradient
- Icon buttons: Circular, size-12, glass effect, glow on hover
- FAB: Fixed bottom-right, gradient, size-16, shadow-2xl, pulse animation

**Dashboard Widgets:**
- Stat Cards: Glass morphic, gradient accent on left border (border-l-4), large numbers with gradient text
- Quick Actions: Icon grid with hover effects
- Recent Activity: Timeline with connecting gradient lines
- Progress Circles: Animated gradient strokes
- Chart Cards: Glass container with gradient axis lines

**AI Feature Components:**
- AI Chat Box: Cyan gradient border (border-2), glass background, rounded-2xl
- AI Suggestions: Card with teal gradient accent, sparkle icon, apply/dismiss actions
- Smart Input: Integrated AI button with cyan glow, auto-suggest dropdown with glass effect
- Loading AI: Gradient shimmer animation across card

**Forms & Inputs:**
- Input fields: Glass morphic bg, rounded-xl, border-white/10, px-6 py-4, focus:border-primary focus:ring-4 focus:ring-primary/20
- Floating labels: Animate up on focus
- Textareas: Same styling, min-h-40
- Checkboxes/Radio: Custom with gradient fill when checked
- Submit buttons: Full gradient with hover glow

**Modals:**
- Backdrop: Blur with dark overlay (backdrop-blur-md bg-black/60)
- Container: Glass morphic, rounded-3xl, p-8, max-w-2xl
- Slide-up on mobile (from-bottom), fade-scale on desktop

**Data Visualization:**
- Charts: Gradient fills, glowing data points, smooth animations
- Progress bars: h-3, rounded-full, gradient fill, glow effect
- Circular progress: Gradient stroke (from-purple to-cyan)

---

## Animations & Interactions

**Gradient Animations:**
- Hero background: Slow rotating mesh gradient (10s infinite)
- Card borders: Gradient animation on hover (1s)
- Text gradients: Subtle shimmer effect

**Micro-interactions:**
- Button press: Scale 0.95, glow intensifies
- Card hover: Lift (translateY -8px), glow appears (300ms ease)
- Icon hover: Rotate 15deg + color shift (200ms)
- Input focus: Border glow spreads outward
- Toggle switches: Smooth slide with gradient trail

**Page Transitions:**
- Fade + slight scale (250ms)
- Slide-up modals with spring (350ms)
- Stagger animations for card grids (delay 50ms each)

**Loading States:**
- Skeleton: Gradient shimmer animation (1.5s infinite)
- Spinners: Rotating gradient ring
- Progress: Smooth width transitions with glow

---

## PWA Features

**Mobile Optimizations:**
- Full-height sections with safe areas
- Sticky bottom nav with glass effect
- Swipe gestures for navigation
- Pull-to-refresh with gradient indicator
- Haptic feedback on interactions

**Glass Navigation Bar:**
- backdrop-blur-2xl, border-t border-white/10
- Active tab: gradient indicator + glow
- Icons: size-6, with smooth color transitions

---

## Page-Specific Layouts

**Landing Page:**
1. Hero: Full viewport, animated gradient, headline + subheading + dual CTAs, 3D hero image right
2. Social Proof Bar: Scrolling logos with gradient fade edges
3. Features: 3-column cards with icons, hover effects (py-24)
4. Benefits: Alternating text/image rows with gradient accents (py-20)
5. How It Works: Timeline with connecting gradient lines (py-24)
6. Testimonials: 3 cards with user photos, gradient borders (py-20)
7. Pricing: 3 tiers, middle highlighted with gradient glow (py-24)
8. Final CTA: Full-width gradient section with large button (py-32)
9. Footer: 4-column grid, newsletter with gradient button

**Dashboard:**
- Top: Stats row with 4 glass cards showing metrics
- Widgets grid: Mix of sizes (span-2 for featured widgets)
- Quick actions: Glass floating action panel
- Recent plans: Masonry cards with progress indicators
- AI assistant: Floating chat bubble (bottom-right)

**Plan Detail:**
- Header: Glass card with plan title, progress circle, gradient accent
- AI suggestions panel: Cyan gradient border, collapsible
- Steps: Interactive list with drag handles, gradient checkboxes
- Timeline view: Gradient connecting lines between milestones
- Comments: Glass threaded discussion

**Profile:**
- Cover image: Gradient mesh background
- Avatar: Large circular with gradient border ring
- Stats: 4 glass cards in row
- Settings: Glass sections with toggle switches
- Activity feed: Timeline with gradient accents

---

## Images

**Hero Image (Landing):**
- Description: Modern 3D rendered scene showing floating UI elements, productivity dashboard mockup, or abstract planning visualization with vibrant purple/cyan color scheme
- Placement: Right 50% on desktop (object-cover), below hero text on mobile, max-h-screen
- Style: High-quality, futuristic, with subtle glow effects matching brand gradients
- Overlay: Gradient fade from left (from-background to-transparent)

**Feature Section Images:**
- Screenshot mockups: Dashboard views with gradient borders, shadow-2xl
- Icon illustrations: Custom gradient icons for features
- Background patterns: Subtle gradient mesh patterns

**Empty States:**
- Illustrations: Gradient colored icons/graphics
- Style: Modern, minimal, matching purple-cyan theme

---

**Design Delivery:** This creates a visually stunning, premium SaaS experience that feels modern and engaging. The vibrant gradients and glass morphism elevate the productivity tool beyond utilitarian design, while maintaining clarity and usability.